using System;
using System.Data;
using System.Data.Common;
using System.Collections.Generic;
using System.Text;

namespace FactoryConnect
{
   class Program
   {
      static void Main(string[] args)
      {
         DbProviderFactory factory =
           DbProviderFactories.GetFactory("System.Data.SqlClient");
         using (DbConnection conn = factory.CreateConnection())
         {
            conn.ConnectionString =
              @"data source=.\SQLExpress; initial catalog=SampleDB; Integrated Security=SSPI;";
            conn.Open();

            DbCommand cmd = factory.CreateCommand();
            cmd.CommandText = "SELECT * FROM Customers";
            cmd.Connection = conn;
            DbDataReader rdr = cmd.ExecuteReader();
            while (rdr.Read())
            {
               Console.WriteLine("{0}, {1} {2}",
                 rdr["LastName"], rdr["FirstName"], rdr["MiddleInitial"]);
            }
         }
         Console.ReadLine();
      }
   }
}
